/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

public class ByteArrayEncoderHTTP
implements ByteArrayEncoder {
    static final String DEFAULT_ENCODING = "UTF-8";
    private String bound = null;
    private String encoding = "UTF-8";
    boolean closed = false;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int encodedLength = -1;
    private byte[] encodedByteArray = null;
    private UploadPolicy uploadPolicy;
    private Writer writer;

    public ByteArrayEncoderHTTP(UploadPolicy uploadPolicy) throws JUploadIOException {
        this.init(uploadPolicy, null, DEFAULT_ENCODING);
    }

    public ByteArrayEncoderHTTP(UploadPolicy uploadPolicy, String bound) throws JUploadIOException {
        this.init(uploadPolicy, bound, DEFAULT_ENCODING);
    }

    public ByteArrayEncoderHTTP(UploadPolicy uploadPolicy, String bound, String encoding) throws JUploadIOException {
        this.init(uploadPolicy, bound, encoding);
    }

    public synchronized void close() throws JUploadIOException {
        if (this.isClosed()) {
            throw new JUploadIOException("Trying to close an already closed ByteArrayEncoded");
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        this.encodedByteArray = this.baos.toByteArray();
        this.encodedLength = this.encodedByteArray.length;
        this.closed = true;
    }

    public ByteArrayEncoder append(String str) throws JUploadIOException {
        try {
            this.writer.append(str);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        return this;
    }

    public ByteArrayEncoder append(int b) throws JUploadIOException {
        try {
            this.writer.flush();
            this.baos.write(b);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        return this;
    }

    public ByteArrayEncoder append(byte[] b) throws JUploadIOException {
        try {
            this.writer.flush();
            this.baos.write(b);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        return this;
    }

    public ByteArrayEncoder append(ByteArrayEncoder bae) throws JUploadIOException {
        this.append(bae.getEncodedByteArray());
        return this;
    }

    public ByteArrayEncoder appendTextProperty(String name, String value, int index) throws JUploadIOException {
        String propertySuffix = "";
        if (index >= 0) {
            if (this.uploadPolicy.getHttpUploadParameterType().equals("array")) {
                propertySuffix = "[]";
            } else if (this.uploadPolicy.getHttpUploadParameterType().equals("iteration")) {
                propertySuffix = Integer.toString(index);
            }
        }
        this.append(this.bound).append("\r\n");
        this.append("Content-Disposition: form-data; name=\"").append(name).append(propertySuffix).append("\"\r\n");
        this.append("Content-Transfer-Encoding: 8bit\r\n");
        this.append("Content-Type: text/plain; charset=").append(this.getEncoding()).append("\r\n");
        this.append("\r\n");
        this.append(value).append("\r\n");
        return this;
    }

    public ByteArrayEncoder appendEndPropertyList() throws JUploadIOException {
        this.append(this.bound).append("--\r\n");
        return this;
    }

    public ByteArrayEncoder appendFormVariables(String formname) throws JUploadIOException {
        String action = "Entering ByteArrayEncoderHTTP.appendFormVariables() [html form: " + formname + "]";
        try {
            this.uploadPolicy.displayDebug(action, 80);
            action = "win = netscape.javascript.JSObject.getWindow";
            this.uploadPolicy.displayDebug("Before " + action + " (this.uploadPolicy.getContext().getApplet(): " + this.uploadPolicy.getContext().getApplet() + ")", 80);
            JSObject win = JSObject.getWindow((Applet)this.uploadPolicy.getContext().getApplet());
            this.uploadPolicy.displayDebug("After " + action + " (win: " + win + ")", 80);
            action = "o = win.eval";
            Object o = win.eval("document.forms[\"" + formname + "\"].elements.length");
            if (o instanceof Number) {
                int len = ((Number)o).intValue();
                if (len <= 0) {
                    this.uploadPolicy.displayWarn("The specified form \"" + formname + "\" does not contain any elements.");
                }
                for (int i = 0; i < len; ++i) {
                    try {
                        String t;
                        action = "name = win.eval";
                        Object name = win.eval("document.forms[\"" + formname + "\"][" + i + "].name");
                        action = "value = win.eval";
                        Object value = win.eval("document.forms[\"" + formname + "\"][" + i + "].value");
                        action = "elementType = win.eval";
                        Object elementType = win.eval("document.forms[\"" + formname + "\"][" + i + "].type");
                        action = "elementClass = win.eval";
                        action = "etype = win.eval";
                        Object etype = win.eval("document.forms[\"" + formname + "\"][" + i + "].type");
                        if (etype instanceof String && ((t = (String)etype).equals("checkbox") || t.equals("radio"))) {
                            action = "on = win.eval";
                            Object on = win.eval("document.forms[\"" + formname + "\"][" + i + "].checked");
                            if (on instanceof Boolean && !((Boolean)on).booleanValue()) {
                                this.uploadPolicy.displayDebug("  [ByteArrayEncoder.appendFormVariables] Skipping unchecked checkboxes and radiobuttons", 80);
                                continue;
                            }
                        }
                        if (name instanceof String && ((String)name).length() > 0) {
                            if (value instanceof String) {
                                this.uploadPolicy.displayDebug("  [ByteArrayEncoder.appendFormVariables] Adding formdata element num " + i + " (name: " + name + ", value: " + value + ", type: " + elementType + ")", 80);
                                this.appendTextProperty((String)name, (String)value, -1);
                                continue;
                            }
                            this.uploadPolicy.displayWarn("  [ByteArrayEncoder.appendFormVariables] Value must be an instance of String (name: " + name + ", value: )" + value + ")");
                            continue;
                        }
                        this.uploadPolicy.displayWarn("  [ByteArrayEncoder.appendFormVariables] Name must be an instance of String (name: " + name + ", value: )" + value + ")");
                        continue;
                    }
                    catch (JSException e1) {
                        this.uploadPolicy.displayWarn(e1.getStackTrace()[1] + ": got JSException in ByteArrayEncoderHTTP.appendFormVariables() [html form: " + formname + "] - bailing out (action: " + action + ")");
                        i = len;
                    }
                }
            } else {
                this.uploadPolicy.displayWarn("  [ByteArrayEncoder.appendFormVariables] The specified form \"" + formname + "\" could not be found (or has no element).");
            }
        }
        catch (JSException e) {
            this.uploadPolicy.displayDebug(e.getStackTrace()[1] + ": No JavaScript available (action: " + action + ")", 10);
        }
        this.uploadPolicy.displayDebug("  [ByteArrayEncoder.appendFormVariables] End of ByteArrayEncoderHTTP.appendFormVariables()", 80);
        return this;
    }

    public String getBoundary() {
        return this.bound;
    }

    public static String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getEncodedLength() throws JUploadIOException {
        if (!this.isClosed()) {
            throw new JUploadIOException("Trying to get length of a on non-closed ByteArrayEncoded");
        }
        return this.encodedLength;
    }

    public byte[] getEncodedByteArray() throws JUploadIOException {
        if (!this.isClosed()) {
            throw new JUploadIOException("Trying to get the byte array of a on non-closed ByteArrayEncoded");
        }
        return this.encodedByteArray;
    }

    public String getString() throws JUploadIOException {
        if (!this.isClosed()) {
            throw new JUploadIOException("Trying to get the byte array of a on non-closed ByteArrayEncoded");
        }
        try {
            return new String(this.encodedByteArray, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadIOException(e);
        }
    }

    private void init(UploadPolicy uploadPolicy, String bound, String encoding) throws JUploadIOException {
        this.uploadPolicy = uploadPolicy;
        this.encoding = encoding;
        this.bound = bound;
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.baos, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadIOException(e);
        }
    }
}

