<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Address extends MX_Controller {
	public $table = "address";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("address_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="adactive";
			$this->load->view('dashboard/header',$data);	
			$address=$this->address_model->getAllbanners();
			$data["address"]=$address;
			$this->load->view('address',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createaddress()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="adactive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createaddress');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveaddress()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$params=array(
				'phone' => $this->input->post("phone"),								'phone1' => $this->input->post("phone1"),
				'email' =>$this->input->post("email"),
				'address' => $this->input->post("address"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}address";
			$address=$this->address_model->storeItems($table,$params);
			if($address == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/address");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create ."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/address");
			}					
			
		}
	}	
	
	public function editaddress($addressid)
	{
		$addressid=str_replace("_","=",base64_decode($addressid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="adactive";
			$this->load->view('dashboard/header',$data);
			$data["addressid"]=$addressid;
			$address=$this->address_model->getaddressid($addressid);
			$data["address"]=$address;
			//print_r($address);die();
	
			$this->load->view('editaddress',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateaddress()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$addressid=$this->input->post("addressid");
			
			$params=array(
				
				'phone' => $this->input->post("phone"),								'phone1' => $this->input->post("phone1"),
				'email' =>$this->input->post("email"),
				'address' => $this->input->post("address"),
				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}address";
			$address=$this->address_model->updateItems($table,$params,$addressid);
			if($address == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  address Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/address");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update address."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/address");
			}
			
		}
	}
	
	
	public function deleteaddress($addressid)
	{
		$addressid=str_replace("_","=",base64_decode($addressid));		
		$address=$this->address_model->deleteaddress($addressid);
		if($address == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/address");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/address");
		}
		
	}
	
	public function inactiveItem($addressid)
	{
		//$addressid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->address_model->itemStatusMode($this->table,$params,$addressid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/address");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/address");
		}
	}
	
	public function activeItem($addressid)
	{
		//$addressid=str_replace("_","=",base64_decode($addressid));
		$params=array(
			"status" => 1
		);
		$success=$this->address_model->itemStatusMode($this->table,$params,$addressid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/address");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/address");
		}
	}
	
	
	
	
}

