<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Banner extends MX_Controller {
	public $table = "banners";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("banner_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$data["menu"]="bhanuactive";
			$this->load->view('dashboard/header',$data);	
			$banner=$this->banner_model->getAllbanner();
			$data["banner"]=$banner;
			//print_r($banner);
			$this->load->view('banner',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createbanner()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="bhanuactive";
			$this->load->view('dashboard/header',$data);
			$this->load->view('create-banner');
			$this->load->view('dashboard/footer');
		}
	}
	public function savebanner()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$vid=explode(".",$_FILES["mainImage"]["name"]);
			$bannerimg=time().".".end($vid);
			
			$params=array(
				'pagetype' => $this->input->post("pagetype"),							
				'banner_image' => $bannerimg,							
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}banners";
			$banner=$this->banner_model->storeItems($table,$params);
			if($banner == 1)
			{	
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/banners/".$bannerimg);
				$success_categories=array(
					'success_categories' => "Successfully Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/banner");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/banner");
			}					
			
		}
	}	
	
	public function editbanner($bannerid)
	{
		$bannerid=str_replace("_","=",base64_decode($bannerid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="bhanuactive";
			$this->load->view('dashboard/header',$data);
			$data["bannerid"]=$bannerid;
			$banner=$this->banner_model->getbannerid($bannerid);
			$data["banner"]=$banner;
			//print_r($banner);die();
			
			$this->load->view('edit-banner',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatebanner()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$bannerid=$this->input->post("bannerid");

			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);
				$bannerimg=time().".".end($category);
			
				$deleteExistvideo=$this->banner_model->removeExistsvideo($bannerid);
				if($deleteExistvideo == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/banners/".$bannerimg);
				}
				else
				{
					$err_categories=array(
					'err_categories' => "Updation Failed."
					);
					$this->session->set_userdata($err_categories);
					redirect(base_url()."index.php/banner/editbanner/".str_replace("=","_",base64_encode($bannerid)));
				}					
				
			}
			else
			{
				$bannerimg=$this->input->post("hiddenmainImage");
			}	
				
			$params=array(
				
				'pagetype' => $this->input->post("pagetype"),
				'banner_image' => $bannerimg,							
				'created_date' => @date("Y-m-d H:i:s"),				
				
			);
			//print_r($params);die();
			$table="{PRE}banners";
			$banner=$this->banner_model->updateItems($table,$params,$bannerid);
			if($banner == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/banner");
			}
			else{
				$err_categories=array(
					'err_categories' => "Updation Failed."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/banner");
			}
			
		}
	}
	
	
	public function deletebanner($bannerid)
	{
		$bannerid=str_replace("_","=",base64_decode($bannerid));
		$banner=$this->banner_model->deletebanner($bannerid);
		if($banner == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/banner");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/banner");
		}
		
	}
	
	public function checkpageExists($pagetype)
	{
		$check=$this->banner_model->checkpageExists($pagetype);
		if(@sizeOf($check) > 0)
		{
			echo 1;
		}
		else
		{
			echo 0;
		}
	}
	
	
	
	
}

