<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Banners extends MX_Controller {
	public $table = "banners";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("banners_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$data["menu"]="hbactive";
			$this->load->view('dashboard/header',$data);	
			$banners=$this->banners_model->getAllbanners();
			$data["banners"]=$banners;
			//print_r($banners);
			$this->load->view('banners',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createbanners()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="hbactive";
			$this->load->view('dashboard/header',$data);
			$this->load->view('create-banners');
			$this->load->view('dashboard/footer');
		}
	}
	public function savebanners()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$vid=explode(".",$_FILES["mainImage"]["name"]);
			$bannersimg=time().".".end($vid);
			
			$params=array(
				'banner_image' => $bannersimg,	
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}home_banners";
			$banners=$this->banners_model->storeItems($table,$params);
			if($banners == 1)
			{	
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/aboutus/".$bannersimg);
				$success_categories=array(
					'success_categories' => "Successfully Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/banners");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/banners");
			}					
			
		}
	}	
	
	public function editbanners($bannersid)
	{
		$bannersid=str_replace("_","=",base64_decode($bannersid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="hbactive";
			$this->load->view('dashboard/header',$data);
			$data["bannersid"]=$bannersid;
			$banners=$this->banners_model->getbannersid($bannersid);
			$data["banners"]=$banners;
			//print_r($banners);die();
			
			$this->load->view('edit-banners',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatebanners()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$bannersid=$this->input->post("bannersid");

			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);
				$bannersimg=time().".".end($category);
			
				$deleteExistvideo=$this->banners_model->removeExistsvideo($bannersid);
				if($deleteExistvideo == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/aboutus/".$bannersimg);
				}
				else
				{
					$err_categories=array(
					'err_categories' => "Updation Failed."
					);
					$this->session->set_userdata($err_categories);
					redirect(base_url()."index.php/banners/editbanners/".str_replace("=","_",base64_encode($bannersid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}	
				$bannerdate=$this->input->post('fromdate');
				$bannertodate=$this->input->post('todate');
			$params=array(
										
				'banner_image' => $bannersimg,							
				'created_date' => @date("Y-m-d H:i:s"),				
				
			);
			//print_r($params);die();
			$table="{PRE}home_banners";
			$banners=$this->banners_model->updateItems($table,$params,$bannersid);
			if($banners == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/banners");
			}
			else{
				$err_categories=array(
					'err_categories' => "Updation Failed."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/banners");
			}
			
		}
	}
	
	
	public function deletebanners($bannersid)
	{
		$bannersid=str_replace("_","=",base64_decode($bannersid));
		$banners=$this->banners_model->deletebanners($bannersid);
		if($banners == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/banners");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/banners");
		}
		
	}
	
	
	
	
	
	
}

