<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends MX_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('dashboard_model');		
		
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{			
			$this->load->view('header');
			$this->load->view('index');
			$this->load->view('footer');
		}
		
	}
	
	public function changePassword()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php");
		}
		else
		{
			
			$userid=$this->session->userdata("userid");
			$data['userid']=$userid;
			
			$this->load->view('header');
			$this->load->view('changepassword');
			$this->load->view('footer');
		}
	}
	
	public function update()
	{
		$params=array(
			'firstname' => $this->input->post("firstname"),
			'lastname' => $this->input->post("lastname"),
			'email' => $this->input->post("email"),
			'password' => SHA1($this->input->post("npassword"))
		);
		
		$update=$this->dashboard_model->update($params,$this->session->userdata("userid"));
		if($update == 1)
		{
			$this->session->set_userdata(array("succ_blog" => "Your New Email/Password Updated.Please Login To Continue"));
			redirect(base_url()."index.php/login/logout");
		}
		else{
			$this->session->set_userdata(array("err_user" => "Failed to Update Email/Password"));
			redirect(base_url()."index.php/dashboard/changePassword");
		}
	}
	
	public function enquiries()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{			
		    $data['menu'] = 'enquiries';
		    $enquiries=$this->dashboard_model->getAllTableRows("55web_contact_us");
		    $data['enquiries'] = $enquiries;
			$this->load->view('header',$data);
			$this->load->view('enquiries',$data);
			$this->load->view('footer',$data);
		}
		
	}
	
	public function deleteEnquiry($subscribeuserid)
	{
		$subscribeuserid=str_replace("_","=",base64_decode($subscribeuserid));		
		$subscribeuser=$this->dashboard_model->deleteItem("55web_contact_us",array("id" => $subscribeuserid));
		if($subscribeuser == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/dashboard/enquiries");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/dashboard/enquiries");
		}
		
	}
	
	public function Signup()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{			
		    $data['menu'] = 'enquiries';
		    $enquiries=$this->dashboard_model->getAllTableRows("55web_sign_up");
		    $data['enquiries'] = $enquiries;
			$this->load->view('header',$data);
			$this->load->view('Signup',$data);
			$this->load->view('footer',$data);
		}
		
	}

}

/* End of file users.php */
/* Location: ./application/modules/users/controllers/users.php */