<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Eventvenue extends MX_Controller {
	public $table = "event_venue";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("eventvenue_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="vactive";
			$this->load->view('dashboard/header',$data);	
			$venue=$this->eventvenue_model->getAllbanners();
			$data["venue"]=$venue;
			$this->load->view('eventvenue',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createeventvenue()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="vactive";
			$this->load->view('dashboard/header',$data);				
			$this->load->view('create-eventvenue');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveeventvenue()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$venue=explode(".",$_FILES["mainImage"]["name"]);
			$bannersimg=time().".".end($venue);

			//$venues=explode(".",$_FILES["mapImage"]["name"]);
			//$mapimg="map".time().".".end($venues);			
			
			$params=array( 
				
				'venue_name' => $this->input->post("venue_name"),
				'description' => $this->input->post("description"),
				'services' => $this->input->post("services"),							
				'hotel_address' => $this->input->post("hotel_address"),							
				'banner_image' => $bannersimg,				
				//'hotel_lat' => $this->input->post("hotel_lat"),				
				//'hotel_lang' => $this->input->post("hotel_lang"),				
				'hotel_map' => $this->input->post("hotel_map"),				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}event_venue";
			$venue=$this->eventvenue_model->storeItems($table,$params);
			if($venue == 1)
			{
				
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/venues/".$bannersimg);		
				//@move_uploaded_file($_FILES["mapImage"]["tmp_name"],"includes/uploads/venues/".$mapimg);		
				
				$success_categories=array(
					'success_categories' => "Successfully venue Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/eventvenue");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create venue."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/eventvenue");
			}					
			
		}
	}	
	
	public function vieweventvenue($eventvenueid)
	{
		$eventvenueid=str_replace("_","=",base64_decode($eventvenueid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="vactive";
			$this->load->view('dashboard/header',$data);
			$data["eventvenueid"]=$eventvenueid;
			$venue=$this->eventvenue_model->geteventvenueid($eventvenueid);
			$data["venue"]=$venue;
			//print_r($venue);die();
						
			$this->load->view('view-eventvenue',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function editeventvenue($eventvenueid)
	{
		$eventvenueid=str_replace("_","=",base64_decode($eventvenueid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="vactive";
			$this->load->view('dashboard/header',$data);
			$data["eventvenueid"]=$eventvenueid;
			$venue=$this->eventvenue_model->geteventvenueid($eventvenueid);
			$data["venue"]=$venue;
			//print_r($venue);die();
						
			$this->load->view('edit-eventvenue',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateeventvenue()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$eventvenueid=$this->input->post("eventvenueid");
			
			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);
				$bannersimg=time().".".end($category);
			
				$deleteExistimage=$this->eventvenue_model->removeExistsimage($eventvenueid);
				if($deleteExistimage == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/venues/".$bannersimg);
				}
				else
				{
					$this->session->set_userdata($err_msg);
					redirect(base_url()."index.php/eventvenue/editeventvenue/".str_replace("=","_",base64_encode($eventvenueid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}

			/*if(@$_FILES["mapImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mapImage"]["name"]);
				$mapimg="map".time().".".end($category);
			
				$deleteExistimage=$this->eventvenue_model->removeExistsimage1($eventvenueid);
				if($deleteExistimage == 1)
				{
					@move_uploaded_file($_FILES["mapImage"]["tmp_name"],"includes/uploads/venues/".$mapimg);
				}
				else
				{
					$this->session->set_userdata($err_msg);
					redirect(base_url()."index.php/eventvenue/editeventvenue/".str_replace("=","_",base64_encode($eventvenueid)));
				}					
				
			}
			else
			{
				$mapimg=$this->input->post("hiddenmapImage");
			}	*/		
			
			$params=array(
				
				'venue_name' => $this->input->post("venue_name"),
				'description' => $this->input->post("description"),
				'services' => $this->input->post("services"),							
				'hotel_address' => $this->input->post("hotel_address"),							
				'banner_image' => $bannersimg,				
				//'hotel_lat' => $this->input->post("hotel_lat"),				
				//'hotel_lang' => $this->input->post("hotel_lang"),		
				'hotel_map' => $this->input->post("hotel_map"),		
			);
			//print_r($params);die();
			$table="{PRE}event_venue";
			$venue=$this->eventvenue_model->updateItems($table,$params,$eventvenueid);
			if($venue == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Venue Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/eventvenue");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update Venue."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/eventvenue");
			}
			
		}
	}
	
	
	public function deleteeventvenue($eventvenueid)
	{
		$eventvenueid=str_replace("_","=",base64_decode($eventvenueid));
		$venue=$this->eventvenue_model->deleteeventvenue($eventvenueid);
		if($venue == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/eventvenue");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/eventvenue");
		}
		
	}
	
	public function inactiveItem($eventvenueid)
	{
		//$eventvenueid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->eventvenue_model->itemStatusMode($this->table,$params,$eventvenueid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/eventvenue");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/eventvenue");
		}
	}
	
	public function activeItem($eventvenueid)
	{
		//$eventvenueid=str_replace("_","=",base64_decode($eventvenueid));
		$params=array(
			"status" => 1
		);
		$success=$this->eventvenue_model->itemStatusMode($this->table,$params,$eventvenueid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/eventvenue");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/eventvenue");
		}
	}
	
	
	
	
}

