<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Files extends MX_Controller {
	public $table = "documents";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("files_model");

		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="factive";
			$this->load->view('dashboard/header',$data);	
			$files=$this->files_model->getAllbanners();
			$data["files"]=$files;
			$this->load->view('files',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createfiles()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="factive";
			$this->load->view('dashboard/header',$data);		
			$this->load->view('create-files');
			$this->load->view('dashboard/footer');
		}
	}
	public function savefiles()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$spons=explode(".",$_FILES["mainImage"]["name"]);
			//print_r($spons);die();
		 	$bannersimg=time().".".end($spons);
			
			$params=array(
				'pagetype' => $this->input->post("pagetype"),
				'doc_name' => $bannersimg,
				'created_date' => @date("Y-m-d H:i:s"),				
			);
			//print_r($params);die();
			$table="{PRE}documents";
			$files=$this->files_model->storeItems($table,$params);
			if($files == 1)
			{
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/documents/".$bannersimg);
				$success_categories=array(
					'success_categories' => "Successfully files Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/files");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create files."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/files");
			}					
			
		}
	}	
	
	public function editfiles($filesid)
	{
		$filesid=str_replace("_","=",base64_decode($filesid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="factive";
			$this->load->view('dashboard/header',$data);
			$data["filesid"]=$filesid;
			$files=$this->files_model->getfilesid($filesid);
			$data["files"]=$files;
			//print_r($files);die();
		
			$this->load->view('edit-files',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatefiles()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$filesid = $this->input->post("filesid");
			
			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);				
				$bannersimg=time().".".end($category);
			
				$deleteExistimage=$this->files_model->removeExistsimage($filesid);
				if($deleteExistimage == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/documents/".$bannersimg);
				}
				else
				{
					$err_categories=array(
					'err_categories' => "Failed to Update files."
					);
					$this->session->set_userdata($err_categories);
					redirect(base_url()."index.php/files/editfiles/".str_replace("=","_",base64_encode($filesid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}
			
			
			$params=array(
				
				'pagetype' => $this->input->post("pagetype"),
				'doc_name' => $bannersimg,	
														
			);
			//print_r($params);die();
			$table="{PRE}documents";
			$files=$this->files_model->updateItems($table,$params,$filesid);
			if($files == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully files Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/files");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update files."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/files");
			}
			
		}
	}
	
	
	public function deletefiles($filesid)
	{
		$filesid=str_replace("_","=",base64_decode($filesid));
		$files=$this->files_model->deletefiles($filesid);
		if($files == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/files");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/files");
		}
		
	}
	
	public function inactiveItem($filesid)
	{
		//$filesid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->files_model->itemStatusMode($this->table,$params,$filesid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/files");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/files");
		}
	}
	
	public function activeItem($filesid)
	{
		//$filesid=str_replace("_","=",base64_decode($filesid));
		$params=array(
			"status" => 1
		);
		$success=$this->files_model->itemStatusMode($this->table,$params,$filesid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/files");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/files");
		}
	}
	
	public function checkpageExists($pagetype)
	{
		$check=$this->files_model->checkpageExists($pagetype);
		if(@sizeOf($check) > 0)
		{
			echo 1;
		}
		else
		{
			echo 0;
		}
	}
	
	
	
	
}

