<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Partner extends MX_Controller {
	public $table = "sponcers";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("partner_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index($pagecnt = 0)
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$end=10;
			$data["table"]=$this->table;
			$data["menu"]="bpactive";
			$this->load->view('dashboard/header',$data);
			
			$totalRecords=$this->partner_model->getAllbanners();
			$partner=$this->partner_model->getAllbannerswithlimit($pagecnt,$end);
			
			$this->load->library('pagination');
			$config['base_url'] = base_url().'index.php/partner/index';
			$config['total_rows'] = @sizeOf($totalRecords);
			$config['per_page'] = $end; 
			$config['first_tag_open']="<div>";
			$config['first_tag_close']="</div>";
			$this->pagination->initialize($config);
			$data["pagination"]=$this->pagination->create_links();		
			
			$data["partner"]=$partner;
			//print_r($partner);die();
			$this->load->view('partner',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function view($userid)
	{
		$userid=str_replace("_","=",base64_decode($userid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="bpactive";
			$this->load->view('dashboard/header',$data);
			$userinfo=$this->partner_model->getAlluserdetails($userid);
			$data["userinfo"]=$userinfo;
			//print_r($userinfo);die();
			$this->load->view('userinfo',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	
	
	
	
	
}

