<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Regdescription extends MX_Controller {
	public $table = "guidelines";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("regdescription_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="rcactive";
			$this->load->view('dashboard/header',$data);	
			$regdescription=$this->regdescription_model->getAllbanners();
			$data["regdescription"]=$regdescription;
			$this->load->view('regdescription',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createregdescription()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="rcactive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createregdescription');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveregdescription()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$pagetype="4";
			$params=array(
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),
			'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$regdescription=$this->regdescription_model->storeItems($table,$params);
			if($regdescription == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/regdescription");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create ."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/regdescription");
			}					
			
		}
	}	
	
	public function editregdescription($regdescriptionid)
	{
		$regdescriptionid=str_replace("_","=",base64_decode($regdescriptionid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="rcactive";
			$this->load->view('dashboard/header',$data);
			$data["regdescriptionid"]=$regdescriptionid;
			$regdescription=$this->regdescription_model->getregdescriptionid($regdescriptionid);
			$data["regdescription"]=$regdescription;
			//print_r($regdescription);die();
	
			$this->load->view('editregdescription',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateregdescription()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$regdescriptionid=$this->input->post("regdescriptionid");
		$pagetype="4";
			$params=array(
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),
				'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$regdescription=$this->regdescription_model->updateItems($table,$params,$regdescriptionid);
			if($regdescription == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  regdescription Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/regdescription");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update regdescription."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/regdescription");
			}
			
		}
	}
	
	
	public function deleteregdescription($regdescriptionid)
	{
		$regdescriptionid=str_replace("_","=",base64_decode($regdescriptionid));		
		$regdescription=$this->regdescription_model->deleteregdescription($regdescriptionid);
		if($regdescription == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/regdescription");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/regdescription");
		}
		
	}
	
	public function inactiveItem($regdescriptionid)
	{
		//$regdescriptionid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->regdescription_model->itemStatusMode($this->table,$params,$regdescriptionid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/regdescription");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/regdescription");
		}
	}
	
	public function activeItem($regdescriptionid)
	{
		//$regdescriptionid=str_replace("_","=",base64_decode($regdescriptionid));
		$params=array(
			"status" => 1
		);
		$success=$this->regdescription_model->itemStatusMode($this->table,$params,$regdescriptionid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/regdescription");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/regdescription");
		}
	}
	
	
	
	
}

