<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Registrationdates extends MX_Controller {
	public $table = "registrations_dates";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("registrationdates_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="regactive";
			$this->load->view('dashboard/header',$data);	
			$registrationdates=$this->registrationdates_model->getAllbanners();
			$data["registrationdates"]=$registrationdates;
			$this->load->view('registrationdates',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createregistrationdates()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="regactive";
			$this->load->view('dashboard/header',$data);		
			$this->load->view('create-registrationdates');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveregistrationdates()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$early_date = $this->input->post("early_date");
			$standard_date = $this->input->post("standard_date");
			$onsite_date = $this->input->post("onsite_date");
			$params=array(
				
				'early_date' => @date('Y-m-d', strtotime($early_date)),					
				'standard_date' => @date('Y-m-d', strtotime($standard_date)),						
				'onsite_date' => @date('Y-m-d', strtotime($onsite_date)),		
						
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}registrations_dates";
			$registrationdates=$this->registrationdates_model->storeItems($table,$params);
			if($registrationdates == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully registrationdates Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/registrationdates");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create registrationdates."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/registrationdates");
			}					
			
		}
	}	
	
	public function editregistrationdates($registrationdatesid)
	{
		$registrationdatesid=str_replace("_","=",base64_decode($registrationdatesid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="regactive";
			$this->load->view('dashboard/header',$data);
			$data["registrationdatesid"]=$registrationdatesid;
			$registrationdates=$this->registrationdates_model->getregistrationdatesid($registrationdatesid);
			$data["registrationdates"]=$registrationdates;
			//print_r($registrationdates);die();
						
			$this->load->view('edit-registrationdates',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateregistrationdates()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$registrationdatesid = $this->input->post("registrationdatesid");
			
			$early_date = $this->input->post("early_date");
			$standard_date = $this->input->post("standard_date");
			$onsite_date = $this->input->post("onsite_date");
			$params=array(
				
				'early_date' => @date('Y-m-d', strtotime($early_date)),					
				'standard_date' => @date('Y-m-d', strtotime($standard_date)),						
				'onsite_date' => @date('Y-m-d', strtotime($onsite_date)),
									
			);
			//print_r($params);die();
			$table="{PRE}registrations_dates";
			$registrationdates=$this->registrationdates_model->updateItems($table,$params,$registrationdatesid);
			if($registrationdates == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully registrationdates Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/registrationdates");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update registrationdates."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/registrationdates");
			}
			
		}
	}
	
	
	public function deleteregistrationdates($registrationdatesid)
	{
		$registrationdatesid=str_replace("_","=",base64_decode($registrationdatesid));
		$registrationdates=$this->registrationdates_model->deleteregistrationdates($registrationdatesid);
		if($registrationdates == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/registrationdates");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/registrationdates");
		}
		
	}
	
	public function inactiveItem($registrationdatesid)
	{
		//$registrationdatesid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->registrationdates_model->itemStatusMode($this->table,$params,$registrationdatesid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/registrationdates");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/registrationdates");
		}
	}
	
	public function activeItem($registrationdatesid)
	{
		//$registrationdatesid=str_replace("_","=",base64_decode($registrationdatesid));
		$params=array(
			"status" => 1
		);
		$success=$this->registrationdates_model->itemStatusMode($this->table,$params,$registrationdatesid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/registrationdates");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/registrationdates");
		}
	}
	
	
	
	
}

