<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Social extends MX_Controller {
	public $table = "social_links";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("social_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="social";
			$this->load->view('dashboard/header',$data);	
			$social=$this->social_model->getAllbanners();
			$data["social"]=$social;
			$this->load->view('social',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createsocial()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="social";
			$this->load->view('dashboard/header',$data);
			$this->load->view('create-social');
			$this->load->view('dashboard/footer');
		}
	}
	public function savesocial()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$params=array(
				'social_network' => $this->input->post("social_network"),			
				'url' => $this->input->post("url"),			
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}social_links";
			$social=$this->social_model->storeItems($table,$params);
			if($social == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully social Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/social");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create social."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/social");
			}					
			
		}
	}	
	
	public function editsocial($socialid)
	{
		$socialid=str_replace("_","=",base64_decode($socialid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
				$data["menu"]="social";
			$this->load->view('dashboard/header',$data);
		
			$data["socialid"]=$socialid;
			$social=$this->social_model->getsocialid($socialid);
			$data["social"]=$social;
			//print_r($social);die();
		
			$this->load->view('edit-social',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatesocial()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$socialid = $this->input->post("socialid");
			$params=array(
				
				'social_network' => $this->input->post("social_network"),
				'url' => $this->input->post("url"),	
														
			);
			//print_r($params);die();
			$table="{PRE}social_links";
			$social=$this->social_model->updateItems($table,$params,$socialid);
			if($social == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully social Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/social");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update social."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/social");
			}
			
		}
	}
	
	
	public function deletesocial($socialid)
	{
		$socialid=str_replace("_","=",base64_decode($socialid));
		$social=$this->social_model->deletesocial($socialid);
		if($social == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/social");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/social");
		}
		
	}
	
	public function inactiveItem($socialid)
	{
		//$socialid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->social_model->itemStatusMode($this->table,$params,$socialid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/social");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/social");
		}
	}
	
	public function activeItem($socialid)
	{
		//$socialid=str_replace("_","=",base64_decode($socialid));
		$params=array(
			"status" => 1
		);
		$success=$this->social_model->itemStatusMode($this->table,$params,$socialid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/social");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/social");
		}
	}
	
	
	
	
}

