<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class User extends MX_Controller {

	public $table = "admin_users";

	public function __construct()

	{

		parent::__construct();

		$this->load->model("user_model");		

	

		if($this->session->userdata("is_logged_in") != 1)

		{

			redirect(base_url()."index.php/login");

		}

	}

	public function index($pagecnt = 0)

	{

		if($this->session->userdata("is_logged_in") != 1)

		{

			redirect(base_url()."index.php/login");

		}

		else

		{			

			$data["table"]=$this->table;

			

			$this->load->view('dashboard/header');	

		

			$user=$this->user_model->getAllbanners();

			$data["user"]=$user;

			$this->load->view('user',$data);

			$this->load->view('dashboard/footer');

		}

	}

	

	public function createuser()

	{

		$this->load->view('dashboard/header');		

		$this->load->view('create-user');

		$this->load->view('dashboard/footer');

	}

	

	public function saveuser()

	{	  

		$table = "{PRE}admin_users";

		$params=array(

		   "firstname" => $this->input->post("firstname"),

		   "lastname" =>$this->input->post("lastname"),		 

		   "email" => $this->input->post("email"),

		   "password" =>  SHA1($this->input->post("password")),

		   "mobile" => $this->input->post("mobile"),

		   "usertype" => '2',

		   "created_date" => @date("Y-m-d H:i:s")

		);

		//print_r($params);die();

		$store=$this->user_model->storeItems($table,$params);

		if($store > 0)

		{

			$success_reg=array(

			 'success_reg' => "Successfully Admin User Created."

			);

			$this->session->set_userdata($success_reg);

			redirect(base_url()."index.php/user");

		}

		else

		{

			$err_reg=array(

			  'err_reg' => "Failed To Craete Admin User."

			);

			$this->session->set_userdata($err_reg);

			redirect(base_url()."index.php/user/createuser");

		}

				

	}

		

	public function deleteuser($userid)

	{

		

		//echo $userid;die();

		$delete=$this->user_model->deleteuserdetails($userid);

		if($delete == 1)

		{

			$success_msg=array(

				'success_user' => "Successfully User Deleted."

			);

			$this->session->set_userdata($success_msg);

			redirect(base_url()."index.php/user");

		}

		else{

			$err_msg=array(

				'err_user' => "Failed to Delete User."

			);

			$this->session->set_userdata($err_msg);

			redirect(base_url()."index.php/user");

		}

	}

	

}



