<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users_model extends CI_Model {
	
	public function getAllbanners()
	{
		$this->db->select("a.*,b.designation_name,c.country_name")->from("{PRE}users a")->where("a.user_type",1);
		$this->db->join("{PRE}designation b","a.designation = b.id","LEFT");
		$this->db->join("{PRE}country c","a.country = c.id","LEFT");
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function getAllbannerswithlimit($start,$end)
	{
		$this->db->select("a.*,b.designation_name,c.country_name")->from("{PRE}users a")->where("a.user_type",1)->order_by("a.id","DESC");
		$this->db->join("{PRE}designation b","a.designation = b.id","LEFT");
		$this->db->join("{PRE}country c","a.country = c.id","LEFT");
		$this->db->limit($end,$start);
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function getAbstractuserdetails()
	{
		$this->db->select("a.*,b.designation_name,c.country_name")->from("{PRE}users a")->where("a.user_type",2);
		$this->db->join("{PRE}designation b","a.designation = b.id","LEFT");
		$this->db->join("{PRE}country c","a.country = c.id","LEFT");
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function getAbstractuserdetailswithlimit($start,$end)
	{
		$this->db->select("a.*,b.designation_name,c.country_name")->from("{PRE}users a")->where("a.user_type",2)->order_by("a.id","DESC");
		$this->db->join("{PRE}designation b","a.designation = b.id","LEFT");
		$this->db->join("{PRE}country c","a.country = c.id","LEFT");
		$this->db->limit($end,$start);
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function getdiscountuserdetails()
	{
		$this->db->select("a.*,b.designation_name,c.country_name")->from("{PRE}user_dicount_reg a");
		$this->db->join("{PRE}designation b","a.designation = b.id","LEFT");
		$this->db->join("{PRE}country c","a.country = c.id","LEFT");
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function getdiscountuserdetailswithlimit($start,$end)
	{
		$this->db->select("a.*,b.designation_name,c.country_name")->from("{PRE}user_dicount_reg a")->order_by("a.id","DESC");
		$this->db->join("{PRE}designation b","a.designation = b.id","LEFT");
		$this->db->join("{PRE}country c","a.country = c.id","LEFT");
		$this->db->limit($end,$start);
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}

	public function getAlluserdetails($userid)
	{
		$this->db->select("a.*,b.presentation_type,b.conference_theme,b.document,d.registration_type as mentortype,e.session_title")->from("{PRE}user_registrations_dates a")->where(array("a.user_id" => $userid));
		$this->db->join("{PRE}users b","a.user_id = b.id","LEFT");		
		$this->db->join("{PRE}registrations_amount d","a.registration_type = d.id","LEFT");
		$this->db->join("{PRE}sessions e","b.conference_theme = e.id","LEFT");
		$query=$this->db->get();
		//echo $this->db->last_query();die();
		
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}	
	
	public function getAlluserdetailsss($userid)
	{
		$this->db->select("a.*,b.session_title")->from("{PRE}users a")->where(array("a.id" => $userid));
		$this->db->join("{PRE}sessions b","a.conference_theme = b.id","LEFT");		
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function getdiscount($userid)
	{
		$this->db->select("a.*,b.registration_type as mentortype,e.session_title")->from("{PRE}user_dicount_reg a")->where(array("a.id" => $userid));
		
		$this->db->join("{PRE}registrations_amount b","a.reg_type = b.id","LEFT");
		$this->db->join("{PRE}sessions e","a.conference_theme = e.id","LEFT");
		$query=$this->db->get();
		//echo $this->db->last_query();die();
		
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function storeItems($table,$params)
	{
		$query=$this->db->insert($table,$params);
		if($query)
		{
			return 1;
		}
		else{
			return 0;
		}
	}
	
	public function updateItems($table,$params,$descriptionid)
	{
		$query=$this->db->update($table,$params,array("id" => $descriptionid));
		if($query)
		{
			return 1;
		}
		else{
			return 0;
		}
	}
	
	public function getdescriptionid($descriptionid)
	{
		
		$this->db->select("*")->from("{PRE}users")->where("id",$descriptionid);
		$query=$this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return array();
		}
	}
	
	public function deletecontent($descriptionid)
	{		
		$this->db->select("*")->from("{PRE}users")->where(array("id" => $descriptionid));		
		$query=$this->db->get();		
		if($query->num_rows() == 1)
		{	
			$deletequery=$this->db->delete("{PRE}users",array("id" => $descriptionid));
			if($deletequery)
			{
				return 1;
			}
			else
			{
				return 0;
			}
		}
	}
	
	
	
	public function itemStatusMode($table,$params,$descriptionid)
	{
		$query=$this->db->update("{PRE}".$table,$params,array("id" => $descriptionid));
		if($query)
		{
			return 1;
		}
		else{
			return 0;
		}
	}
	
	
	
}
