<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Whyattend extends MX_Controller {
	public $table = "whyattend";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("whyattend_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="wtactive";
			$this->load->view('dashboard/header',$data);	
			$whyattend=$this->whyattend_model->getAllbanners();
			$data["whyattend"]=$whyattend;
			$this->load->view('whyattend',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createwhyattend()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="wtactive";
			$this->load->view('dashboard/header',$data);		
			$this->load->view('createwhyattend');
			$this->load->view('dashboard/footer');
		}
	}
	public function savewhyattend()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'description' => $this->input->post("description"),
				'color' => $this->input->post("color"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}whyattend";
			$whyattend=$this->whyattend_model->storeItems($table,$params);
			if($whyattend == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/whyattend");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create address."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/whyattend");
			}					
			
		}
	}	
	
	public function editwhyattend($whyattendid)
	{
		$whyattendid=str_replace("_","=",base64_decode($whyattendid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="wtactive";
			$this->load->view('dashboard/header',$data);
			$data["whyattendid"]=$whyattendid;
			$whyattend=$this->whyattend_model->getwhyattendid($whyattendid);
			$data["whyattend"]=$whyattend;
			//print_r($whyattend);die();
	
			$this->load->view('editwhyattend',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatewhyattend()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$whyattendid=$this->input->post("whyattendid");
			
			$params=array(
				
				'description' => $this->input->post("description"),
				'color' => $this->input->post("color"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}whyattend";
			$whyattend=$this->whyattend_model->updateItems($table,$params,$whyattendid);
			if($whyattend == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully   Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/whyattend");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update address."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/whyattend");
			}
			
		}
	}
	
	
	
	
	
	
	
	
	public function deletewhyattend($whyattendid)
	{
		$whyattendid=str_replace("_","=",base64_decode($whyattendid));		
		$whyattend=$this->whyattend_model->deletewhyattend($whyattendid);
		if($whyattend == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/whyattend");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/whyattend");
		}
		
	}
	
	
	
	
	
	
	
	
	public function inactiveItem($whyattendid)
	{
		//$addressid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->whyattend_model->itemStatusMode($this->table,$params,$whyattendid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/whyattend");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/whyattend");
		}
	}
	
	public function activeItem($whyattendid)
	{
		//$addressid=str_replace("_","=",base64_decode($whyattendid));
		$params=array(
			"status" => 1
		);
		$success=$this->whyattend_model->itemStatusMode($this->table,$params,$whyattendid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/whyattend");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/whyattend");
		}
	}
	
	
	
	
}

