<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Broucher extends MX_Controller {
	public $table = "brochure";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("broucher_model");

		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="bractive";
			$this->load->view('dashboard/header',$data);	
			$broucher=$this->broucher_model->getAllbanners();
			$data["broucher"]=$broucher;
			$this->load->view('broucher',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createbroucher()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="bractive";
			$this->load->view('dashboard/header',$data);		
			$this->load->view('create-broucher');
			$this->load->view('dashboard/footer');
		}
	}
	public function savebroucher()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$spons=explode(".",$_FILES["mainImage"]["name"]);
			$bannersimg="broucher".".".end($spons);
			
			$params=array(
				
				'brouchure_name' => $bannersimg,
								
			);
			//print_r($params);die();
			$table="{PRE}brochure";
			$broucher=$this->broucher_model->storeItems($table,$params);
			if($broucher == 1)
			{
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/brouchure/".$bannersimg);
				$success_categories=array(
					'success_categories' => "Successfully broucher Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/broucher");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create broucher."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/broucher");
			}					
			
		}
	}	
	
	public function editbroucher($broucherid)
	{
		$broucherid=str_replace("_","=",base64_decode($broucherid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="bractive";
			$this->load->view('dashboard/header',$data);
			$data["broucherid"]=$broucherid;
			$broucher=$this->broucher_model->getbroucherid($broucherid);
			$data["broucher"]=$broucher;
			//print_r($broucher);die();
		
			$this->load->view('edit-broucher',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatebroucher()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$broucherid = $this->input->post("broucherid");
			
			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);				
				$bannersimg="broucher".".".end($category);
			
				$deleteExistimage=$this->broucher_model->removeExistsimage($broucherid);
				if($deleteExistimage == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/brouchure/".$bannersimg);
				}
				else
				{
					$err_categories=array(
					'err_categories' => "Failed to Update broucher."
					);
					$this->session->set_userdata($err_categories);
					redirect(base_url()."index.php/broucher/editbroucher/".str_replace("=","_",base64_encode($broucherid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}
			
			
			$params=array(
				
				'brouchure_name' => $bannersimg,	
														
			);
			//print_r($params);die();
			$table="{PRE}brochure";
			$broucher=$this->broucher_model->updateItems($table,$params,$broucherid);
			if($broucher == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully broucher Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/broucher");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update broucher."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/broucher");
			}
			
		}
	}
	
	
	public function deletebroucher($broucherid)
	{
		$broucherid=str_replace("_","=",base64_decode($broucherid));
		$broucher=$this->broucher_model->deletebroucher($broucherid);
		if($broucher == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/broucher");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/broucher");
		}
		
	}
	
	public function inactiveItem($broucherid)
	{
		//$broucherid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->broucher_model->itemStatusMode($this->table,$params,$broucherid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/broucher");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/broucher");
		}
	}
	
	public function activeItem($broucherid)
	{
		//$broucherid=str_replace("_","=",base64_decode($broucherid));
		$params=array(
			"status" => 1
		);
		$success=$this->broucher_model->itemStatusMode($this->table,$params,$broucherid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/broucher");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/broucher");
		}
	}
	
	
	
	
}

