<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Country extends MX_Controller {
	public $table = "country";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("country_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="coactive";
			$this->load->view('dashboard/header',$data);	
			$country=$this->country_model->getAllbanners();
			$data["country"]=$country;
			//print_r($country);
			$this->load->view('country',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createcountry()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="coactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('create-country');
			$this->load->view('dashboard/footer');
		}
	}
	public function savecountry()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$params=array(
				
				'country_name' => $this->input->post("country"),							
				'country_code' => $this->input->post("country_code"),							
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}country";
			$country=$this->country_model->storeItems($table,$params);
			if($country == 1)
			{			
				$success_categories=array(
					'success_categories' => "Successfully Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/country");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/country");
			}					
			
		}
	}	
	
	public function editcountry($countryid)
	{
		$countryid=str_replace("_","=",base64_decode($countryid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="coactive";
			$this->load->view('dashboard/header',$data);
			$data["countryid"]=$countryid;
			$country=$this->country_model->getcountryid($countryid);
			$data["country"]=$country;
			//print_r($country);die();
		
			$this->load->view('edit-country',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatecountry()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$countryid=$this->input->post("countryid");

			$params=array(
				
				'country_name' => $this->input->post("country"),							
				'country_code' => $this->input->post("country_code"),							
				
			);
			
			$table="{PRE}country";
			$country=$this->country_model->updateItems($table,$params,$countryid);
			if($country == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/country");
			}
			else{
				$err_categories=array(
					'err_categories' => "Updation Failed."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/country");
			}
			
		}
	}
	
	
	public function deletecountry($countryid)
	{
		$countryid=str_replace("_","=",base64_decode($countryid));
		$country=$this->country_model->deletecountry($countryid);
		if($country == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/country");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/country");
		}
		
	}
	
	
	
	
	
	
}

