<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Guidelines extends MX_Controller {
	public $table = "guidelines";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("guidelines_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="glactive";
			$this->load->view('dashboard/header',$data);	
			$guidelines=$this->guidelines_model->getAllbanners();
			$data["guidelines"]=$guidelines;
			$this->load->view('guidelines',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createguidelines()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="glactive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createguidelines');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveguidelines()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$pagetype="1";
			$params=array(
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),
			'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$guidelines=$this->guidelines_model->storeItems($table,$params);
			if($guidelines == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/guidelines");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create ."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/guidelines");
			}					
			
		}
	}	
	
	public function editguidelines($guidelinesid)
	{
		$guidelinesid=str_replace("_","=",base64_decode($guidelinesid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="glactive";
			$this->load->view('dashboard/header',$data);
			$data["guidelinesid"]=$guidelinesid;
			$guidelines=$this->guidelines_model->getguidelinesid($guidelinesid);
			$data["guidelines"]=$guidelines;
			//print_r($guidelines);die();
	
			$this->load->view('editguidelines',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateguidelines()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$guidelinesid=$this->input->post("guidelinesid");
		$pagetype="1";
			$params=array(
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),
				'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$guidelines=$this->guidelines_model->updateItems($table,$params,$guidelinesid);
			if($guidelines == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  guidelines Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/guidelines");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update guidelines."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/guidelines");
			}
			
		}
	}
	
	
	public function deleteguidelines($guidelinesid)
	{
		$guidelinesid=str_replace("_","=",base64_decode($guidelinesid));		
		$guidelines=$this->guidelines_model->deleteguidelines($guidelinesid);
		if($guidelines == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/guidelines");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/guidelines");
		}
		
	}
	
	public function inactiveItem($guidelinesid)
	{
		//$guidelinesid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->guidelines_model->itemStatusMode($this->table,$params,$guidelinesid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/guidelines");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/guidelines");
		}
	}
	
	public function activeItem($guidelinesid)
	{
		//$guidelinesid=str_replace("_","=",base64_decode($guidelinesid));
		$params=array(
			"status" => 1
		);
		$success=$this->guidelines_model->itemStatusMode($this->table,$params,$guidelinesid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/guidelines");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/guidelines");
		}
	}
	
	
	
	
}

