<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mentorregistration extends MX_Controller {
	public $table = "regi_mentor_roles";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("mentorregistration_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$this->load->view('dashboard/header');	
			$mentorregistration=$this->mentorregistration_model->getAllbanners();
			$data["mentorregistration"]=$mentorregistration;
			$this->load->view('mentorregistration',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function creatementorregistration()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');			
			$this->load->view('create-mentorregistration');
			$this->load->view('dashboard/footer');
		}
	}
	public function savementorregistration()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'mentor_role' => $this->input->post("registration_type"),					
				'mentor_role' => $this->input->post("mentor_desc"),					
				'early_amount' => $this->input->post("early_amount"),					
				'standard_amount' =>  $this->input->post("standard_amount"),						
				'onsite_amount' => $this->input->post("onsite_amount"),		
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}regi_mentor_roles";
			$mentorregistration=$this->mentorregistration_model->storeItems($table,$params);
			if($mentorregistration == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully mentorregistration Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/mentorregistration");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create mentorregistration."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/mentorregistration");
			}					
			
		}
	}	
	
	public function editmentorregistration($mentorregistrationid)
	{
		$mentorregistrationid=str_replace("_","=",base64_decode($mentorregistrationid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
			$data["mentorregistrationid"]=$mentorregistrationid;
			$table = 'regi_mentor_roles';
			$mentorregistration=$this->mentorregistration_model->getmentorregistrationid($table,$mentorregistrationid);
			$data["mentorregistration"]=$mentorregistration;
			//print_r($mentorregistration);die();
			
			$this->load->view('edit-mentorregistration',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatementorregistration()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$mentorregistrationid = $this->input->post("mentorregistrationid");
			
			$params=array(
				
				'mentor_role' => $this->input->post("registration_type"),
				'mentor_desc' => $this->input->post("mentor_desc"),
				'early_amount' => $this->input->post("early_amount"),					
				'standard_amount' =>  $this->input->post("standard_amount"),						
				'onsite_amount' => $this->input->post("onsite_amount"),											
			);
			//print_r($params);die();
			$table="{PRE}regi_mentor_roles";
			$mentorregistration=$this->mentorregistration_model->updateItems($table,$params,$mentorregistrationid);
			if($mentorregistration == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully mentorregistration Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/mentorregistration");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update mentorregistration."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/mentorregistration");
			}
			
		}
	}
	
	
	public function deletementorregistration($mentorregistrationid)
	{
		$mentorregistrationid=str_replace("_","=",base64_decode($mentorregistrationid));
		$mentorregistration=$this->mentorregistration_model->deletementorregistration($mentorregistrationid);
		if($mentorregistration == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/mentorregistration");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/mentorregistration");
		}
		
	}
	
	public function inactiveItem($mentorregistrationid)
	{
		//$mentorregistrationid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->mentorregistration_model->itemStatusMode($this->table,$params,$mentorregistrationid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/mentorregistration");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/mentorregistration");
		}
	}
	
	public function activeItem($mentorregistrationid)
	{
		//$mentorregistrationid=str_replace("_","=",base64_decode($mentorregistrationid));
		$params=array(
			"status" => 1
		);
		$success=$this->mentorregistration_model->itemStatusMode($this->table,$params,$mentorregistrationid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/mentorregistration");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/mentorregistration");
		}
	}
	
	
	
	
	
}

