<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Registration extends MX_Controller {
	public $table = "registrations_amount";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("registration_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$this->load->view('dashboard/header');	
			$registration=$this->registration_model->getAllbanners();
			$data["registration"]=$registration;
			$this->load->view('registration',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createregistration()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');		
			$this->load->view('create-registration');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveregistration()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'registration_type' => $this->input->post("registration_type"),					
				'registration_desc' => $this->input->post("registration_desc"),					
				'early_amount' => $this->input->post("early_amount"),					
				'standard_amount' =>  $this->input->post("standard_amount"),						
				'onsite_amount' => $this->input->post("onsite_amount"),		
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}registrations_amount";
			$registration=$this->registration_model->storeItems($table,$params);
			if($registration == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully registration Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/registration");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create registration."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/registration");
			}					
			
		}
	}	
	
	public function editregistration($registrationid)
	{
		$registrationid=str_replace("_","=",base64_decode($registrationid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
			$data["registrationid"]=$registrationid;
			$table = 'registrations_amount';
			$registration=$this->registration_model->getregistrationid($table,$registrationid);
			$data["registration"]=$registration;
			//print_r($registration);die();
		
			$this->load->view('edit-registration',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateregistration()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$registrationid = $this->input->post("registrationid");
			
			$params=array(
				
				'registration_type' => $this->input->post("registration_type"),
				'registration_desc' => $this->input->post("registration_desc"),
				'early_amount' => $this->input->post("early_amount"),					
				'standard_amount' =>  $this->input->post("standard_amount"),						
				'onsite_amount' => $this->input->post("onsite_amount"),											
			);
			//print_r($params);die();
			$table="{PRE}registrations_amount";
			$registration=$this->registration_model->updateItems($table,$params,$registrationid);
			if($registration == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully registration Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/registration");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update registration."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/registration");
			}
			
		}
	}
	
	
	public function deleteregistration($registrationid)
	{
		$registrationid=str_replace("_","=",base64_decode($registrationid));
		$registration=$this->registration_model->deleteregistration($registrationid);
		if($registration == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/registration");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/registration");
		}
		
	}
	
	public function inactiveItem($registrationid)
	{
		//$registrationid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->registration_model->itemStatusMode($this->table,$params,$registrationid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/registration");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/registration");
		}
	}
	
	public function activeItem($registrationid)
	{
		//$registrationid=str_replace("_","=",base64_decode($registrationid));
		$params=array(
			"status" => 1
		);
		$success=$this->registration_model->itemStatusMode($this->table,$params,$registrationid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/registration");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/registration");
		}
	}
	public function discount(){
		$this->load->view('dashboard/header');
		
		$data['amount'] = $this->registration_model->getInfo();
		$this->load->view('discountreg',$data);
		$this->load->view('dashboard/footer');
	}

	public function editDiscount($registrationid)
	{
		$registrationid=str_replace("_","=",base64_decode($registrationid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
			$table = 'discount';
			$data["registrationid"]=$registrationid;
			$registration=$this->registration_model->getregistrationid($table,$registrationid);
			$data["registration"]=$registration;
			//print_r($registration);die();
			
			$this->load->view('edit-discount',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateDiscount()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$registrationid = $this->input->post("registrationid");
			
			$params=array(
				
				'discount_amount' => $this->input->post("disc_amount"),														
			);
			//print_r($params);die();
			$table="{PRE}discount";
			$registration=$this->registration_model->updateItems($table,$params,$registrationid);
			if($registration == 1)
			{
				$success_discount=array(
					'success_discount' => "Successfully Discount Amount Updated."
				);
				$this->session->set_userdata($success_discount);
				redirect(base_url()."index.php/registration/discount");
			}
			else{
				$err_discount=array(
					'err_discount' => "Failed to Update Discount Amount."
				);
				$this->session->set_userdata($err_discount);
				redirect(base_url()."index.php/registration/discount");
			}
			
		}
	}

	public function creatediscountamt(){
		$this->load->view('dashboard/header');		
		$this->load->view('create-discount-amount');
		$this->load->view('dashboard/footer');
	}
	public function saveDiscountAmount()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'discount_amount' => $this->input->post("disc_amount"),			
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}discount";
			$registration=$this->registration_model->storeItems($table,$params);
			if($registration == 1)
			{
				$success_discount=array(
					'success_discount' => "Successfully registration Created."
				);
				$this->session->set_userdata($success_discount);
				redirect(base_url()."index.php/registration/discount");
			}
			else
			{
				$err_discount=array(
					'err_discount' => "Failed to create registration."
				);
				$this->session->set_userdata($err_discount);
				redirect(base_url()."index.php/registration/discount");
			}					
			
		}
	}	
	
	
	
	
}

