<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sessions extends MX_Controller {
	public $table = "sessions";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("sessions_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="seactive";
			$this->load->view('dashboard/header',$data);	
			$sessions=$this->sessions_model->getAllbanners();
			$data["sessions"]=$sessions;
			$this->load->view('sessions',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createsessions()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="seactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('create-sessions');
			$this->load->view('dashboard/footer');
		}
	}
	public function savesessions()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$params=array(
				
				'session_title' => $this->input->post("title"),				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}sessions";
			$sessions=$this->sessions_model->storeItems($table,$params);
			if($sessions == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully sessions Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/sessions/createsessions");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create sessions."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/sessions/createsessions");
			}					
			
		}
	}	
	
	public function editsessions($sessionsid)
	{
		$sessionsid=str_replace("_","=",base64_decode($sessionsid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="seactive";
			$this->load->view('dashboard/header',$data);
			$data["sessionsid"]=$sessionsid;
			$sessions=$this->sessions_model->getsessionsid($sessionsid);
			$data["sessions"]=$sessions;
			//print_r($sessions);die();
		
			$this->load->view('edit-sessions',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatesessions()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$sessionsid = $this->input->post("sessionsid");
			$params=array(
			
				
				'session_title' => $this->input->post("title"),
													
			);
			//print_r($params);die();
			$table="{PRE}sessions";
			$sessions=$this->sessions_model->updateItems($table,$params,$sessionsid);
			if($sessions == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully sessions Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/sessions");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update sessions."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/sessions");
			}
			
		}
	}
	
	
	public function deletesessions($sessionsid)
	{
		$sessionsid=str_replace("_","=",base64_decode($sessionsid));
		$sessions=$this->sessions_model->deletesessions($sessionsid);
		if($sessions == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/sessions");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/sessions");
		}
		
	}
	
	public function inactiveItem($sessionsid)
	{
		//$sessionsid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->sessions_model->itemStatusMode($this->table,$params,$sessionsid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/sessions");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/sessions");
		}
	}
	
	public function activeItem($sessionsid)
	{
		//$sessionsid=str_replace("_","=",base64_decode($sessionsid));
		$params=array(
			"status" => 1
		);
		$success=$this->sessions_model->itemStatusMode($this->table,$params,$sessionsid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/sessions");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/sessions");
		}
	}
	
	
	
	
}

