<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sessionsdesc extends MX_Controller {
	public $table = "sessions_content";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("sessionsdesc_model");
		$this->load->model("sessions/sessions_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="sdactive";
			$this->load->view('dashboard/header',$data);	
			$sessionsdesc=$this->sessionsdesc_model->getAllbanners();
			$data["sessionsdesc"]=$sessionsdesc;
		
			$this->load->view('sessionsdesc',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createsessionsdesc()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="sdactive";
			$this->load->view('dashboard/header',$data);
			$sessions=$this->sessionsdesc_model->getAllbanners();
			$data["sessions"]=$sessions;
		
			$this->load->view('create-sessionsdesc',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function savesessionsdesc()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$params=array(
				
				
				
				'description' => $this->input->post("description"),				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}sessions_desc";
			$sessionsdesc=$this->sessionsdesc_model->storeItems($table,$params);
			if($sessionsdesc == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully sessionsdesc Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/sessionsdesc");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create sessionsdesc."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/sessionsdesc/createsessionsdesc");
			}					
			
		}
	}	
	
	public function editsessionsdesc($sessionsdescid)
	{
		$sessionsdescid=str_replace("_","=",base64_decode($sessionsdescid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="sdactive";
			$this->load->view('dashboard/header',$data);
			$data["sessionsdescid"]=$sessionsdescid;
			$sessionsdesc=$this->sessionsdesc_model->getsessionsdescid($sessionsdescid);
			$data["sessionsdesc"]=$sessionsdesc;
			//print_r($sessionsdesc);die();
			$sessions=$this->sessions_model->getAllbanners();
			$data["sessions"]=$sessions;
		
			$this->load->view('edit-sessionsdesc',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatesessionsdesc()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$sessionsdescid = $this->input->post("sessionsdescid");
			$params=array(
			
				
				
				'description' => $this->input->post("description"),
			);
			//print_r($params);die();
			$table="{PRE}sessions_desc";
			$sessionsdesc=$this->sessionsdesc_model->updateItems($table,$params,$sessionsdescid);
			if($sessionsdesc == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully sessionsdesc Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/sessionsdesc");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update sessionsdesc."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/sessionsdesc");
			}
			
		}
	}
	
	
	public function deletesessionsdesc($sessionsdescid)
	{
		$sessionsdescid=str_replace("_","=",base64_decode($sessionsdescid));
		$sessionsdesc=$this->sessionsdesc_model->deletesessionsdesc($sessionsdescid);
		if($sessionsdesc == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/sessionsdesc");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/sessionsdesc");
		}
		
	}
	
	public function inactiveItem($sessionsdescid)
	{
		//$sessionsdescid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->sessionsdesc_model->itemStatusMode($this->table,$params,$sessionsdescid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/sessionsdesc");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/sessionsdesc");
		}
	}
	
	public function activeItem($sessionsdescid)
	{
		//$sessionsdescid=str_replace("_","=",base64_decode($sessionsdescid));
		$params=array(
			"status" => 1
		);
		$success=$this->sessionsdesc_model->itemStatusMode($this->table,$params,$sessionsdescid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/sessionsdesc");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/sessionsdesc");
		}
	}
	
	
	
	
}

