<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Target extends MX_Controller {
	public $table = "description";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("target_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="taractive";
			$this->load->view('dashboard/header',$data);	
			$target=$this->target_model->getAllbanners();
			$data["target"]=$target;
			$this->load->view('target',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createtarget()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="taractive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createtarget');
			$this->load->view('dashboard/footer');
		}
	}
	public function savetarget()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$pagetype="2";
			$params=array(
				
				'description' => $this->input->post("description"),
				'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}description";
			$target=$this->target_model->storeItems($table,$params);
			if($target == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/target");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create ."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/target");
			}					
			
		}
	}	
	
	public function edittarget($targetid)
	{
		$targetid=str_replace("_","=",base64_decode($targetid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="taractive";
			$this->load->view('dashboard/header',$data);
			$data["targetid"]=$targetid;
			$target=$this->target_model->gettargetid($targetid);
			$data["target"]=$target;
			//print_r($target);die();
	
			$this->load->view('edittarget',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatetarget()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$targetid=$this->input->post("targetid");
			$pagetype="2";
			$params=array(
				
				'description' => $this->input->post("description"),
				'pagetype'=>$pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}description";
			$target=$this->target_model->updateItems($table,$params,$targetid);
			if($target == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  target Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/target");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update target."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/target");
			}
			
		}
	}
	
	
	public function deletetarget($targetid)
	{
		$targetid=str_replace("_","=",base64_decode($targetid));		
		$target=$this->target_model->deletetarget($targetid);
		if($target == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/target");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/target");
		}
		
	}
	
	public function inactiveItem($targetid)
	{
		//$targetid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->target_model->itemStatusMode($this->table,$params,$targetid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/target");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/target");
		}
	}
	
	public function activeItem($targetid)
	{
		//$targetid=str_replace("_","=",base64_decode($targetid));
		$params=array(
			"status" => 1
		);
		$success=$this->target_model->itemStatusMode($this->table,$params,$targetid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/target");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/target");
		}
	}
	
	
	
	
}

