const express = require('express');
const mysql = require('mysql');
const cors = require('cors'); // Make sure this line exists
const path = require('path');
const multer = require('multer');
const stripe = require('stripe')('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'); // Replace with your Stripe secret key


// Create the router
const router = express.Router();

// enable CORS for all routes
router.use(cors());

// OR enable CORS with specific settings
router.use(cors({
    origin: '*', // Allow all origins (change in production)
    methods: ['GET', 'POST', 'PUT', 'DELETE'],
    allowedHeaders: ['Content-Type', 'Authorization']
}));

const fileFilter = (req, file, cb) => {
  const allowedExtensions = ['pdf', 'doc', 'docx'];
  const allowedMimeTypes = [
    'application/pdf',
    'application/msword', // .doc
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document' // .docx
  ];

  const fileExtension = file.originalname.split('.').pop().toLowerCase();
  const isExtensionAllowed = allowedExtensions.includes(fileExtension);
  const isMimeTypeAllowed = allowedMimeTypes.includes(file.mimetype);

  if (isExtensionAllowed && isMimeTypeAllowed) {
    cb(null, true); // ✅ Allow upload
  } else {
    cb(new Error('Only .pdf, .doc, and .docx files are allowed!'), false); // ❌ Reject upload
  }
};

const upload = multer({
  storage: multer.diskStorage({
    destination: (req, file, cb) => {
      cb(null, '../includes/uploads/');
    },
    filename: (req, file, cb) => {
      cb(null, Date.now() + '-' + file.originalname);
    }
  }),
  fileFilter: fileFilter
});

const pool = require('./db'); // Import the database connection

// Define the route to fetch data
router.get('/tittle', (req, res) => {
  const query = 'SELECT * FROM `55web_title`';

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});


//About conference
router.get('/aboutconference', (req, res) => {
  const query = 'SELECT * FROM 55web_description WHERE pagetype = 1;';

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});
// comittee
router.get('/comittee', (req, res) => {
  const query = 'SELECT * FROM `55web_comittee` WHERE pagetype = 1;';

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// sessions list

router.get('/sessionslist', (req, res) => {
  const query = 'SELECT * FROM 55web_sessions WHERE status = 1';

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});
// testimonialslist
router.get('/testimonials', (req, res) => {
  const query = 'SELECT * FROM 55web_about_us_mentors';

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// agenda
router.get('/agenda', (req, res) => {
  const query = `
    SELECT * FROM 55web_latest_news
    WHERE pagetype IN ('Day 1', 'Day 2','poster','virtual')
    ORDER BY pagetype, sort_o ASC
  `;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      return res.status(500).json({ error: 'Failed to fetch data' });
    }

    // Group data by pagetype
    const groupedData = results.reduce((acc, item) => {
      acc[item.pagetype] = acc[item.pagetype] || [];
      acc[item.pagetype].push(item);
      return acc;
    }, {});

    res.json(groupedData); // Return grouped data
  });
});

router.get('/homebanner', (req, res) => {
  const query = `
    SELECT * FROM 55web_home_banners WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      return res.status(500).json({ error: 'Failed to fetch data' });
    }


    res.json(results); // Return data
  });
});

// past image gallery
router.get('/pastimage', (req, res) => {
  const query = `
    SELECT * FROM 55web_image_gallery  WHERE status = 1 ORDER BY pagetype DESC LIMIT 10`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      return res.status(500).json({ error: 'Failed to fetch data' });
    }


    res.json(results); // Return data
  });
});

// speakers list
router.get('/speakerlist', (req, res) => {
  const query = `
    SELECT * FROM 55web_speakers  WHERE status = 1 ORDER BY created_date DESC`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      return res.status(500).json({ error: 'Failed to fetch data' });
    }


    res.json(results); // Return data
  });
});

// keynote speakers
router.get('/keynote_speakers', (req, res) => {
  const query = `SELECT * FROM 55web_comittee WHERE pagetype = 2`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});
// static data count
router.get('/static_countdata', (req, res) => {
  const query = `SELECT * FROM 55web_static_data WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

router.get('/aboutus', (req, res) => {
  const query = `SELECT * FROM 55web_description WHERE pagetype = 3`;
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});
//contactUS
router.get('/contactus', (req, res) => {
  const query = 'SELECT * FROM `55web_address` WHERE status = 1';
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});

//contact form 
router.post('/contact', async (req, res) => {
    try {
        const { name, email, phone, message } = req.body;

        if (!name || !email || !phone || !message) {
            return res.status(400).json({ error: 'All fields are required' });
        }

        const query = `INSERT INTO 55web_contact_us (name, email, phone, message, status, created_date) 
                       VALUES (?, ?, ?, ?, 1, NOW())`;

        pool.query(query, [name, email, phone, message], (err, results) => {
            if (err) {
                console.error('Database error:', err);
                return res.status(500).json({ error: 'Database error', details: err.message });
            }
            res.status(200).json({ message: 'Message sent successfully', data: results });
        });

    } catch (err) {
        console.error('Server error:', err);
        res.status(500).json({ error: 'Server error', details: err.message });
    }
});

//contactUS
router.get('/ourfeature', (req, res) => {
  const query = 'SELECT * FROM `55web_sessions_content` WHERE status = 1';
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});
//registrationamount
router.get('/registrationamount', (req, res) => {
  const query = 'SELECT registration_type, early_amount FROM `55web_registrations_amount` WHERE status = 1 LIMIT 2';
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});

//contactUS
router.get('/faq', (req, res) => {
  const query = 'SELECT * FROM `55web_sessions_desc` WHERE status = 1';
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});

//contactUS
router.post('/subscribe', (req, res) => {
  const { name, email } = req.body;
  if (!name || !email) {
    return res.status(400).send({ error: true, message: 'Please provide name and email' });
  }
   pool.query('INSERT INTO 55web_subscribe_users (user_name, user_email) VALUES (?, ?)', [name, email], (error, results) => {
    if (error) throw error;
    res.send({ error: false, data: results, message: 'Subscription successful.' });
  });
});

router.post('/brochureSubmit', async (req, res) => {
  const { firstName, lastName, designation, email, company, queries, country, mobile } = req.body;
  try {
    const result = await  pool.query(
      'INSERT INTO 55web_brouchure_users (firstname, lastname, designation, email, university, message, country, phone) VALUES (?, ?, ?, ?, ?, ?, ?, ?)',
      [firstName, lastName, designation, email, company, queries, country, mobile]
    );
    
    // Define the path to the file
    const brochurePath = path.join(__dirname, '../administrative/includes/uploads/brouchure/broucher.pdf');

    // Send the file as an attachment
    res.download(brochurePath, 'brochure.pdf', (err) => {
      if (err) {
        console.error('Error sending file:', err);
        res.status(500).json({ error: 'Error sending file' });
      } else {
        console.log('File sent successfully');
      }
    });
  } catch (error) {
    console.error('Error fetching data:', error);
    res.status(500).json({ error: error.message });
  }
});


// keynote speakers
router.get('/guidelines', (req, res) => {
  const query = `SELECT * FROM 55web_guidelines WHERE pagetype = 1 AND id != 30`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// registration home_page
router.get('/registration_home_page', (req, res) => {
  const query = `SELECT * FROM 55web_guidelines WHERE id IN (28, 29)`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// social media link
router.get('/social_medialink', (req, res) => {
  const query = `SELECT * FROM 55web_social_links WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// important date
router.get('/important_date', (req, res) => {
  const query = `SELECT * FROM 55web_description WHERE pagetype = 2`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});
// venue details
router.get('/venue_details', (req, res) => {
  const query = `SELECT * FROM 55web_event_venue WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// get_designation details
router.get('/get_designation', (req, res) => {
  const query = `SELECT * FROM 55web_designation WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// get_designation details
router.get('/get_country', (req, res) => {
  const query = `SELECT * FROM 55web_country WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// saveAbstractUser
router.post('/saveAbstractUser', upload.single('file'), (req, res) => {
  const {
    designation,
    fullName,
    companyName,
    conferenceTheme,
    email,
    presentaion_type,
    lastname,
    country,
    phone,
    totalamount,
    radioid
  } = req.body;

  const registration_date = new Date();
  const orderid = Math.floor(10000 + Math.random() * 9000000);
  const acc_amount = req.body.accomadation || 0;
  const docfile = req.file ? req.file.filename : '';
  const usertype = 2;


  const userParams = {
    email: email,
    firstname: fullName,
    lastname: lastname,
    mobile: phone,
    country: country,
    designation: designation,
    presentation_type: presentaion_type,
    conference_theme: conferenceTheme,
    company_university: companyName,
    document: docfile,
    user_type: usertype,
    registered_date: registration_date
  };
console.log(userParams)
  const insertUserQuery = 'INSERT INTO 55web_users SET ?';

  pool.query(insertUserQuery, userParams, (err, result) => {
    if (err) {
      console.error('Error inserting user:', err);
      return res.status(500).send('Failed to submit. Please try again.');
    }

    const userId = result.insertId;

    if (usertype == 1) {
      const registrationParams = {
        user_id: userId,
        order_id: orderid,
        mentor_type: 0,
        mentor_amount: acc_amount,
        registration_amount: 0,
        registration_date: registration_date,
        created_date: registration_date
      };

      const insertRegistrationQuery = 'INSERT INTO 55web_user_registrations_dates SET ?';

      pool.query(insertRegistrationQuery, registrationParams, (err) => {
        if (err) {
          console.error('Error inserting registration:', err);
          return res.status(500).send('Failed to submit. Please try again.');
        }

        // Redirect to PayPal or send success response
        res.send('Registration successful. Redirecting to payment...');
      });
    } else if (usertype == 2) {
      // Handle abstract submission logic
      res.status(200).send({ ok: true, message: 'Abstract submitted successfully. We will contact you soon.' });
    } else {
      res.status(400).send('Invalid user type.');
    }
  });
});


router.get('/registrationamountpage', (req, res) => {
  const query = 'SELECT * FROM `55web_registrations_amount` WHERE status = 1';
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});

router.get('/registrationaccommodation', (req, res) => {
  const query = 'SELECT * FROM `55web_accommodation` WHERE status = 1';

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      return res.status(500).json({ error: 'Failed to fetch data', details: err.message });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found' });
    }

    // Transform results into nested structure
    const transformed = results.map(item => ({
      accommodation: item.accommodation,
      amount: item.amount,
      occupancy: {
        single: {
          name: item.single_occupancy,
          available: item.single_occupancy !== null,
          amount: item.single_occupancy_amount
        },
        double: {
          name: item.double_occupancy,
          available: item.double_occupancy !== null,
          amount: item.double_occupancy_amount
        }
      },
      status: item.status
    }));

    res.json(transformed);
  });
});


router.get('/registrationdate', (req, res) => {
  const query = 'SELECT * FROM `55web_registrations_dates` WHERE status = 1';
  
  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err.code, err.message);
      res.status(500).json({ error: 'Failed to fetch data', details: err.message });
      return;
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No data found for the given pagetype' });
    }

    res.json(results); // Send the results as JSON
  });
});
// saveAbstractUser
router.post('/saveregistrationUser', upload.single('file'), (req, res) => {
    console.log(req.body)
  const {
    designation,
    firstname,
    company_name,
    conferenceTheme,
    useremail,
    presentaion_type,
    lastname,
    country,
    mobile,
    totalAmount,
    radioid
  } = req.body;

  const registration_date = new Date();
  const orderid = Math.floor(10000 + Math.random() * 9000000);
  const acc_amount = req.body.accomadation || 0;
  const usertype = 1;


  const userParams = {
    email: useremail,
    firstname: firstname,
    lastname: lastname,
    mobile: mobile,
    country: country,
    designation: designation,
    presentation_type: presentaion_type,
    conference_theme: conferenceTheme,
    company_university: company_name,
    user_type: usertype,
    registered_date: registration_date
  };
console.log(userParams)
  const insertUserQuery = 'INSERT INTO 55web_users SET ?';

  pool.query(insertUserQuery, userParams, (err, result) => {
    if (err) {
      console.error('Error inserting user:', err);
      return res.status(500).send('Failed to submit. Please try again.');
    }

    const userId = result.insertId;

    if (usertype == 1) {
      const registrationParams = {
        user_id: userId,
        order_id: orderid,
        mentor_type: 0,
        mentor_amount: acc_amount,
        registration_amount: totalAmount,
        registration_date: registration_date,
        created_date: registration_date
      };

      const insertRegistrationQuery = 'INSERT INTO 55web_user_registrations_dates SET ?';

      pool.query(insertRegistrationQuery, registrationParams, (err) => {
        if (err) {
          console.error('Error inserting registration:', err);
          return res.status(500).send('Failed to submit. Please try again.');
        }

        // Redirect to PayPal or send success response
        res.status(200).send({ ok: true, message: 'Registration submitted successfully. We will contact you soon.', userID: userId });
      });
    } else if (usertype == 1) {
      // Handle abstract submission logic
      res.status(200).send({ ok: true, message: 'Registration submitted successfully. We will contact you soon.', userID: userId });
    } else {
      res.status(400).send('Invalid user type.');
    }
  });
});

// social media link
router.get('/registratio_content', (req, res) => {
  const query = `SELECT * FROM 55web_guidelines WHERE id = 23`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});
// social media link
router.get('/venue_gallery', (req, res) => {
  const query = `SELECT * FROM 55web_venue_gallery WHERE status = 1`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// privacy_policy
router.get('/privacy_policy', (req, res) => {
  const query = `SELECT * FROM 55web_guidelines WHERE id = 30`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

// terms_conditions
router.get('/terms_conditions', (req, res) => {
  const query = `SELECT * FROM 55web_guidelines WHERE id = 31`;

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch data' });
      return;
    }

    res.json(results); // Send the results as JSON
  });
});

router.get('/get_agenda', (req, res) => {
  const query = "SELECT doc_name FROM `55web_documents` WHERE pagetype = 3";

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch document name' });
      return;
    }

    if (results.length > 0) {
      const docName = results[0].doc_name;
      const brochurePath = path.join(__dirname, '../administrative/includes/uploads/documents', docName);

      // Send the file as an attachment
      res.download(brochurePath, 'agenda.pdf', (err) => {
        if (err) {
          console.error('Error sending file:', err);
          res.status(500).json({ error: 'Error sending file' });
        } else {
          console.log('File sent successfully');
        }
      });
    } else {
      res.status(404).json({ error: 'Document not found' });
    }
  });
});

router.post('/saveRegistrationStatus', async (req, res) => {
  const { userId, status } = req.body;

  const query = `
    INSERT INTO 55web_user_registrations_dates (user_id, status, created_at)
    VALUES (?, ?, NOW())
    ON DUPLICATE KEY UPDATE status = ?, payment_completed_date = NOW()
  `;

  try {
    const [result] = await pool.query(query, [userId, status, status]);
    res.json({ success: true, message: 'Registration status updated successfully', result });
  } catch (error) {
    console.error('Error saving registration status:', error);
    res.status(500).json({ success: false, error: 'Failed to save registration status' });
  }
});

router.post('/create-checkout-session', async (req, res) => {
  const { amount, userId } = req.body;

  try {
    const session = await stripe.checkout.sessions.create({
      payment_method_types: ['card'],
      line_items: [
        {
          price_data: {
            currency: 'usd',
            product_data: {
              name: 'Registration Fee',
            },
            unit_amount: amount * 100, // Convert dollars to cents
          },
          quantity: 1,
        },
      ],
      mode: 'payment',
      success_url: `${req.headers.origin}/success?session_id={CHECKOUT_SESSION_ID}`,
      cancel_url: `${req.headers.origin}/cancel`,
      metadata: {
        userId: userId, // Pass user ID for tracking
      },
    });

    res.json({ url: session.url });
  } catch (error) {
    console.error('Error creating checkout session:', error);
    res.status(500).json({ error: 'Failed to create checkout session' });
  }
});

router.get('/get_abstract', (req, res) => {
  const query = "SELECT doc_name FROM `55web_documents` WHERE pagetype = 1";

  pool.query(query, (err, results) => {
    if (err) {
      console.error('Error executing the query:', err);
      res.status(500).json({ error: 'Failed to fetch document name' });
      return;
    }

    if (results.length > 0) {
      const docName = results[0].doc_name;
      const brochurePath = path.join(__dirname, '../administrative/includes/uploads/documents', docName);

      // Send the file as an attachment
      res.download(brochurePath, 'Abstrct.doc', (err) => {
        if (err) {
          console.error('Error sending file:', err);
          res.status(500).json({ error: 'Error sending file' });
        } else {
          console.log('File sent successfully');
        }
      });
    } else {
      res.status(404).json({ error: 'Document not found' });
    }
  });
});

module.exports = router;
